/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.xsdvalidator;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.xml.xsdvalidator.XsdValidator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class XsdValidatorDialog
extends ActionDialog {
    private static final Class<?> PKG = XsdValidator.class;
    private static final String[] FILETYPES_XML = new String[]{BaseMessages.getString(PKG, (String)"ActionXSDValidator.Filetype.Xml", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionXSDValidator.Filetype.All", (String[])new String[0])};
    private static final String[] FILETYPES_XSD = new String[]{BaseMessages.getString(PKG, (String)"ActionXSDValidator.Filetype.Xsd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionXSDValidator.Filetype.All", (String[])new String[0])};
    private Text wName;
    private Button wAllowExternalEntities;
    private CCombo wXSDSource;
    private TextVar wxmlFilename;
    Label wlxsdFilename;
    private TextVar wxsdFilename;
    Button wbxsdFilename;
    private XsdValidator action;
    private boolean changed;

    public XsdValidatorDialog(Shell parent, XsdValidator action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionXSDValidator.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlAllowExternalEntities = new Label((Composite)this.shell, 131072);
        wlAllowExternalEntities.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.AllowExternalEntities.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAllowExternalEntities);
        FormData fdlAllowExternalEntities = new FormData();
        fdlAllowExternalEntities.left = new FormAttachment(0, 0);
        fdlAllowExternalEntities.right = new FormAttachment(middle, -margin);
        fdlAllowExternalEntities.top = new FormAttachment((Control)this.wName, margin);
        wlAllowExternalEntities.setLayoutData((Object)fdlAllowExternalEntities);
        this.wAllowExternalEntities = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wAllowExternalEntities);
        FormData fdAllowExternalEntities = new FormData();
        fdAllowExternalEntities.left = new FormAttachment(middle, 0);
        fdAllowExternalEntities.top = new FormAttachment((Control)wlAllowExternalEntities, 0, 0x1000000);
        fdAllowExternalEntities.right = new FormAttachment(100, 0);
        this.wAllowExternalEntities.setLayoutData((Object)fdAllowExternalEntities);
        this.wAllowExternalEntities.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsdValidatorDialog.this.action.setChanged();
            }
        });
        Label wlXSDSource = new Label((Composite)this.shell, 131072);
        wlXSDSource.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.XSDSource.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlXSDSource);
        FormData fdlXSDSource = new FormData();
        fdlXSDSource.left = new FormAttachment(0, 0);
        fdlXSDSource.top = new FormAttachment((Control)this.wAllowExternalEntities, margin);
        fdlXSDSource.right = new FormAttachment(middle, -margin);
        wlXSDSource.setLayoutData((Object)fdlXSDSource);
        this.wXSDSource = new CCombo((Composite)this.shell, 2056);
        this.wXSDSource.setEditable(true);
        PropsUi.setLook((Widget)this.wXSDSource);
        this.wXSDSource.addModifyListener(lsMod);
        FormData fdXSDSource = new FormData();
        fdXSDSource.left = new FormAttachment(middle, 0);
        fdXSDSource.top = new FormAttachment((Control)this.wAllowExternalEntities, margin);
        fdXSDSource.right = new FormAttachment(100, -margin);
        this.wXSDSource.setLayoutData((Object)fdXSDSource);
        this.wXSDSource.add(BaseMessages.getString(PKG, (String)"ActionXSDValidator.XSDSource.IS_A_FILE", (String[])new String[0]));
        this.wXSDSource.add(BaseMessages.getString(PKG, (String)"ActionXSDValidator.XSDSource.NO_NEED", (String[])new String[0]));
        this.wXSDSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsdValidatorDialog.this.setXSDSource();
            }
        });
        Label wlxmlFilename = new Label((Composite)this.shell, 131072);
        wlxmlFilename.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.xmlFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlxmlFilename);
        FormData fdlxmlFilename = new FormData();
        fdlxmlFilename.left = new FormAttachment(0, 0);
        fdlxmlFilename.top = new FormAttachment((Control)this.wXSDSource, 2 * margin);
        fdlxmlFilename.right = new FormAttachment(middle, -margin);
        wlxmlFilename.setLayoutData((Object)fdlxmlFilename);
        Button wbxmlFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbxmlFilename);
        wbxmlFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbxmlFilename = new FormData();
        fdbxmlFilename.right = new FormAttachment(100, 0);
        fdbxmlFilename.top = new FormAttachment((Control)this.wXSDSource, 2 * margin);
        wbxmlFilename.setLayoutData((Object)fdbxmlFilename);
        this.wxmlFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wxmlFilename);
        this.wxmlFilename.addModifyListener(lsMod);
        FormData fdxmlFilename = new FormData();
        fdxmlFilename.left = new FormAttachment(middle, 0);
        fdxmlFilename.top = new FormAttachment((Control)this.wXSDSource, 2 * margin);
        fdxmlFilename.right = new FormAttachment((Control)wbxmlFilename, -margin);
        this.wxmlFilename.setLayoutData((Object)fdxmlFilename);
        this.wxmlFilename.addModifyListener(e -> this.wxmlFilename.setToolTipText(this.variables.resolve(this.wxmlFilename.getText())));
        wbxmlFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wxmlFilename, (IVariables)this.variables, (String[])new String[]{"*.xml;*.XML", "*"}, (String[])FILETYPES_XML, (boolean)true));
        this.wlxsdFilename = new Label((Composite)this.shell, 131072);
        this.wlxsdFilename.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.xsdFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlxsdFilename);
        FormData fdlxsdFilename = new FormData();
        fdlxsdFilename.left = new FormAttachment(0, 0);
        fdlxsdFilename.top = new FormAttachment((Control)this.wxmlFilename, margin);
        fdlxsdFilename.right = new FormAttachment(middle, -margin);
        this.wlxsdFilename.setLayoutData((Object)fdlxsdFilename);
        this.wbxsdFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbxsdFilename);
        this.wbxsdFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbxsdFilename = new FormData();
        fdbxsdFilename.right = new FormAttachment(100, 0);
        fdbxsdFilename.top = new FormAttachment((Control)this.wxmlFilename, 0);
        this.wbxsdFilename.setLayoutData((Object)fdbxsdFilename);
        this.wxsdFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wxsdFilename);
        this.wxsdFilename.addModifyListener(lsMod);
        FormData fdxsdFilename = new FormData();
        fdxsdFilename.left = new FormAttachment(middle, 0);
        fdxsdFilename.top = new FormAttachment((Control)this.wxmlFilename, margin);
        fdxsdFilename.right = new FormAttachment((Control)this.wbxsdFilename, -margin);
        this.wxsdFilename.setLayoutData((Object)fdxsdFilename);
        this.wxsdFilename.addModifyListener(e -> this.wxsdFilename.setToolTipText(this.variables.resolve(this.wxsdFilename.getText())));
        this.wbxsdFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wxsdFilename, (IVariables)this.variables, (String[])new String[]{"*.xsd;*.XSD", "*"}, (String[])FILETYPES_XSD, (boolean)true));
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, (Control)this.wxsdFilename);
        this.getData();
        this.setXSDSource();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wAllowExternalEntities.setSelection(this.action.isAllowExternalEntities());
        if (this.action.getXsdSource() != null) {
            if (this.action.getXsdSource().equals("filename")) {
                this.wXSDSource.select(0);
            } else if (this.action.getXsdSource().equals("noneed")) {
                this.wXSDSource.select(1);
            }
        }
        this.wxmlFilename.setText(Const.nullToEmpty((String)this.action.getxmlFilename()));
        this.wxsdFilename.setText(Const.nullToEmpty((String)this.action.getxsdFilename()));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setAllowExternalEntities(this.wAllowExternalEntities.getSelection());
        this.action.setxmlFilename(this.wxmlFilename.getText());
        this.action.setxsdFilename(this.wxsdFilename.getText());
        if (this.wXSDSource.getSelectionIndex() == 0) {
            this.action.setXsdSource("filename");
        } else if (this.wXSDSource.getSelectionIndex() == 1) {
            this.action.setXsdSource("noneed");
        }
        this.dispose();
    }

    private void setXSDSource() {
        if (this.wXSDSource.getSelectionIndex() == 0) {
            this.wlxsdFilename.setEnabled(true);
            this.wxsdFilename.setEnabled(true);
            this.wbxsdFilename.setEnabled(true);
        } else if (this.wXSDSource.getSelectionIndex() == 1) {
            this.wlxsdFilename.setEnabled(false);
            this.wxsdFilename.setEnabled(false);
            this.wbxsdFilename.setEnabled(false);
        }
    }
}

