/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mail;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mail.Mail;
import org.apache.hop.pipeline.transforms.mail.MailData;
import org.w3c.dom.Node;

@Transform(id="Mail", image="mail.svg", name="i18n::Mail.Name", description="i18n::Mail.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::MailMeta.keyword"}, documentationUrl="/pipeline/transforms/mail.html")
public class MailMeta
extends BaseTransformMeta<Mail, MailData> {
    private static final Class<?> PKG = MailMeta.class;
    private static final String CONST_SPACE = "      ";
    private static final String CONST_SPACE_SHORT = "    ";
    private String server;
    private String destination;
    private String destinationCc;
    private String destinationBCc;
    private String replyAddress;
    private String replyName;
    private String subject;
    private boolean includeDate;
    private boolean includeSubFolders;
    private boolean zipFilenameDynamic;
    private boolean isFilenameDynamic;
    private String dynamicFieldname;
    private String dynamicWildcard;
    private String dynamicZipFilename;
    private String sourcefilefoldername;
    private String sourcewildcard;
    private String contactPerson;
    private String contactPhone;
    private String comment;
    private boolean includingFiles;
    private boolean zipFiles;
    private String zipFilename;
    private String ziplimitsize;
    private boolean usingAuthentication;
    private boolean usexoauth2;
    private String authenticationUser;
    private String authenticationPassword;
    private boolean onlySendComment;
    private boolean useHTML;
    private boolean usingSecureAuthentication;
    private boolean usePriority;
    private String port;
    private String priority;
    private String importance;
    private String sensitivity;
    private String secureConnectionType;
    private String encoding;
    private String replyToAddresses;
    private String[] embeddedimages;
    private String[] contentids;
    private boolean attachContentFromField;
    private String attachContentField;
    private String attachContentFileNameField;
    private boolean addMessageToOutput;
    private String messageOutputField;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        return super.clone();
    }

    public void allocate(int value) {
        this.embeddedimages = new String[value];
        this.contentids = new String[value];
    }

    private void readData(Node transformNode) {
        this.setServer(XmlHandler.getTagValue((Node)transformNode, (String)"server"));
        this.setPort(XmlHandler.getTagValue((Node)transformNode, (String)"port"));
        this.setDestination(XmlHandler.getTagValue((Node)transformNode, (String)"destination"));
        this.setDestinationCc(XmlHandler.getTagValue((Node)transformNode, (String)"destinationCc"));
        this.setDestinationBCc(XmlHandler.getTagValue((Node)transformNode, (String)"destinationBCc"));
        this.setReplyToAddresses(XmlHandler.getTagValue((Node)transformNode, (String)"replyToAddresses"));
        this.setReplyAddress(XmlHandler.getTagValue((Node)transformNode, (String)"replyto"));
        this.setReplyName(XmlHandler.getTagValue((Node)transformNode, (String)"replytoname"));
        this.setSubject(XmlHandler.getTagValue((Node)transformNode, (String)"subject"));
        this.setIncludeDate("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_date")));
        this.setIncludeSubFolders("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_subfolders")));
        this.setZipFilenameDynamic("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"zipFilenameDynamic")));
        this.setisDynamicFilename("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"isFilenameDynamic")));
        this.setDynamicFieldname(XmlHandler.getTagValue((Node)transformNode, (String)"dynamicFieldname"));
        this.setDynamicWildcard(XmlHandler.getTagValue((Node)transformNode, (String)"dynamicWildcard"));
        this.setAttachContentFromField("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"attachContentFromField")));
        this.setAttachContentField(XmlHandler.getTagValue((Node)transformNode, (String)"attachContentField"));
        this.setAttachContentFileNameField(XmlHandler.getTagValue((Node)transformNode, (String)"attachContentFileNameField"));
        this.setDynamicZipFilenameField(XmlHandler.getTagValue((Node)transformNode, (String)"dynamicZipFilename"));
        this.setSourceFileFoldername(XmlHandler.getTagValue((Node)transformNode, (String)"sourcefilefoldername"));
        this.setSourceWildcard(XmlHandler.getTagValue((Node)transformNode, (String)"sourcewildcard"));
        this.setContactPerson(XmlHandler.getTagValue((Node)transformNode, (String)"contact_person"));
        this.setContactPhone(XmlHandler.getTagValue((Node)transformNode, (String)"contact_phone"));
        this.setComment(XmlHandler.getTagValue((Node)transformNode, (String)"comment"));
        this.setIncludingFiles("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_files")));
        this.setUsingAuthentication("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"use_auth")));
        this.setUseXOAUTH2("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"usexoauth2")));
        this.setUsingSecureAuthentication("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"use_secure_auth")));
        this.setAuthenticationUser(XmlHandler.getTagValue((Node)transformNode, (String)"auth_user"));
        this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"auth_password")));
        this.setOnlySendComment("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"only_comment")));
        this.setUseHTML("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"use_HTML")));
        this.setUsePriority("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"use_Priority")));
        this.setEncoding(XmlHandler.getTagValue((Node)transformNode, (String)"encoding"));
        this.setPriority(XmlHandler.getTagValue((Node)transformNode, (String)"priority"));
        this.setImportance(XmlHandler.getTagValue((Node)transformNode, (String)"importance"));
        this.setSensitivity(XmlHandler.getTagValue((Node)transformNode, (String)"sensitivity"));
        this.setSecureConnectionType(XmlHandler.getTagValue((Node)transformNode, (String)"secureconnectiontype"));
        this.setZipFiles("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"zip_files")));
        this.setZipFilename(XmlHandler.getTagValue((Node)transformNode, (String)"zip_name"));
        this.setZipLimitSize(XmlHandler.getTagValue((Node)transformNode, (String)"zip_limit_size"));
        this.setAddMessageToOutput("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_message_in_output")));
        this.setMessageOutputField(XmlHandler.getTagValue((Node)transformNode, (String)"message_output_field"));
        Node images = XmlHandler.getSubNode((Node)transformNode, (String)"embeddedimages");
        int nrImages = XmlHandler.countNodes((Node)images, (String)"embeddedimage");
        this.allocate(nrImages);
        for (int i = 0; i < nrImages; ++i) {
            Node fnode = XmlHandler.getSubNodeByNr((Node)images, (String)"embeddedimage", (int)i);
            this.embeddedimages[i] = XmlHandler.getTagValue((Node)fnode, (String)"image_name");
            this.contentids[i] = XmlHandler.getTagValue((Node)fnode, (String)"content_id");
        }
    }

    public void setEmbeddedImage(int i, String value) {
        this.embeddedimages[i] = value;
    }

    public void setEmbeddedImages(String[] value) {
        this.embeddedimages = value;
    }

    public void setContentIds(int i, String value) {
        this.contentids[i] = value;
    }

    public void setContentIds(String[] value) {
        this.contentids = value;
    }

    public void setDefault() {
    }

    public String getXml() throws HopException {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"include_message_in_output", (boolean)this.addMessageToOutput));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"message_output_field", (String)this.messageOutputField));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"server", (String)this.server));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"port", (String)this.port));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"destination", (String)this.destination));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"destinationCc", (String)this.destinationCc));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"destinationBCc", (String)this.destinationBCc));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"replyToAddresses", (String)this.replyToAddresses));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"replyto", (String)this.replyAddress));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"replytoname", (String)this.replyName));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"subject", (String)this.subject));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"include_date", (boolean)this.includeDate));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubFolders));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"zipFilenameDynamic", (boolean)this.zipFilenameDynamic));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"isFilenameDynamic", (boolean)this.isFilenameDynamic));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"attachContentFromField", (boolean)this.attachContentFromField));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"attachContentField", (String)this.attachContentField));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"attachContentFileNameField", (String)this.attachContentFileNameField));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"dynamicFieldname", (String)this.dynamicFieldname));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"dynamicWildcard", (String)this.dynamicWildcard));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"dynamicZipFilename", (String)this.dynamicZipFilename));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"sourcefilefoldername", (String)this.sourcefilefoldername));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"sourcewildcard", (String)this.sourcewildcard));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"contact_person", (String)this.contactPerson));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"contact_phone", (String)this.contactPhone));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"comment", (String)this.comment));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"include_files", (boolean)this.includingFiles));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"zip_files", (boolean)this.zipFiles));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"zip_name", (String)this.zipFilename));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"zip_limit_size", (String)this.ziplimitsize));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"use_auth", (boolean)this.usingAuthentication));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"usexoauth2", (boolean)this.usexoauth2));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"use_secure_auth", (boolean)this.usingSecureAuthentication));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"only_comment", (boolean)this.onlySendComment));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"use_HTML", (boolean)this.useHTML));
        retval.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"use_Priority", (boolean)this.usePriority));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"priority", (String)this.priority));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"importance", (String)this.importance));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"sensitivity", (String)this.sensitivity));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"secureconnectiontype", (String)this.secureConnectionType));
        retval.append("      <embeddedimages>").append(Const.CR);
        if (this.embeddedimages != null) {
            for (int i = 0; i < this.embeddedimages.length; ++i) {
                retval.append("        <embeddedimage>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"image_name", (String)this.embeddedimages[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"content_id", (String)this.contentids[i]));
                retval.append("        </embeddedimage>").append(Const.CR);
            }
        }
        retval.append("      </embeddedimages>").append(Const.CR);
        return retval.toString();
    }

    public void setServer(String s) {
        this.server = s;
    }

    public String getServer() {
        return this.server;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setDestinationCc(String destCc) {
        this.destinationCc = destCc;
    }

    public void setDestinationBCc(String destBCc) {
        this.destinationBCc = destBCc;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDestinationCc() {
        return this.destinationCc;
    }

    public String getDestinationBCc() {
        return this.destinationBCc;
    }

    public void setReplyAddress(String reply) {
        this.replyAddress = reply;
    }

    public String getReplyAddress() {
        return this.replyAddress;
    }

    public void setReplyName(String replyname) {
        this.replyName = replyname;
    }

    public String getReplyName() {
        return this.replyName;
    }

    public void setSubject(String subj) {
        this.subject = subj;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setIncludeDate(boolean incl) {
        this.includeDate = incl;
    }

    public void setIncludeSubFolders(boolean incl) {
        this.includeSubFolders = incl;
    }

    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public String[] getEmbeddedImages() {
        return this.embeddedimages;
    }

    public String[] getContentIds() {
        return this.contentids;
    }

    public boolean isZipFilenameDynamic() {
        return this.zipFilenameDynamic;
    }

    public void setZipFilenameDynamic(boolean isdynamic) {
        this.zipFilenameDynamic = isdynamic;
    }

    public void setisDynamicFilename(boolean isdynamic) {
        this.isFilenameDynamic = isdynamic;
    }

    public void setAttachContentFromField(boolean attachContentFromField) {
        this.attachContentFromField = attachContentFromField;
    }

    public void setAttachContentField(String attachContentField) {
        this.attachContentField = attachContentField;
    }

    public void setAttachContentFileNameField(String attachContentFileNameField) {
        this.attachContentFileNameField = attachContentFileNameField;
    }

    public void setDynamicWildcard(String dynamicwildcard) {
        this.dynamicWildcard = dynamicwildcard;
    }

    public void setDynamicZipFilenameField(String dynamiczipfilename) {
        this.dynamicZipFilename = dynamiczipfilename;
    }

    public String getDynamicZipFilenameField() {
        return this.dynamicZipFilename;
    }

    public String getDynamicWildcard() {
        return this.dynamicWildcard;
    }

    public void setSourceFileFoldername(String sourcefile) {
        this.sourcefilefoldername = sourcefile;
    }

    public String getSourceFileFoldername() {
        return this.sourcefilefoldername;
    }

    public void setSourceWildcard(String wildcard) {
        this.sourcewildcard = wildcard;
    }

    public String getSourceWildcard() {
        return this.sourcewildcard;
    }

    public void setDynamicFieldname(String dynamicfield) {
        this.dynamicFieldname = dynamicfield;
    }

    public String getDynamicFieldname() {
        return this.dynamicFieldname;
    }

    public boolean getIncludeDate() {
        return this.includeDate;
    }

    public boolean isDynamicFilename() {
        return this.isFilenameDynamic;
    }

    public boolean isAttachContentFromField() {
        return this.attachContentFromField;
    }

    public String getAttachContentField() {
        return this.attachContentField;
    }

    public String getAttachContentFileNameField() {
        return this.attachContentFileNameField;
    }

    public void setContactPerson(String person) {
        this.contactPerson = person;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPhone(String phone) {
        this.contactPhone = phone;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setComment(String comm) {
        this.comment = comm;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isIncludingFiles() {
        return this.includingFiles;
    }

    public void setIncludingFiles(boolean includeFiles) {
        this.includingFiles = includeFiles;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public String getZipLimitSize() {
        return this.ziplimitsize;
    }

    public void setZipLimitSize(String ziplimitsize) {
        this.ziplimitsize = ziplimitsize;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public boolean isZipFiles() {
        return this.zipFiles;
    }

    public void setZipFiles(boolean zipFiles) {
        this.zipFiles = zipFiles;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public boolean isUsingAuthentication() {
        return this.usingAuthentication;
    }

    public void setUsingAuthentication(boolean usingAuthentication) {
        this.usingAuthentication = usingAuthentication;
    }

    public boolean isOnlySendComment() {
        return this.onlySendComment;
    }

    public void setOnlySendComment(boolean onlySendComment) {
        this.onlySendComment = onlySendComment;
    }

    public boolean isUseHTML() {
        return this.useHTML;
    }

    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSecureConnectionType() {
        return this.secureConnectionType;
    }

    public void setSecureConnectionType(String secureConnectionType) {
        this.secureConnectionType = secureConnectionType;
    }

    public void setReplyToAddresses(String replyToAddresses) {
        this.replyToAddresses = replyToAddresses;
    }

    public String getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isUsingSecureAuthentication() {
        return this.usingSecureAuthentication;
    }

    public void setUsingSecureAuthentication(boolean usingSecureAuthentication) {
        this.usingSecureAuthentication = usingSecureAuthentication;
    }

    public void setUseXOAUTH2(boolean usexoauth2) {
        this.usexoauth2 = usexoauth2;
    }

    public boolean isUseXOAUTH2() {
        return this.usexoauth2;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getImportance() {
        return this.importance;
    }

    public String getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(String sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = prev == null || prev.size() == 0 ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (Utils.isEmpty((CharSequence)this.server)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            if (prev.indexOfValue(variables.resolve(this.server)) < 0) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ServerFieldNotFound", (String[])new String[]{this.server}), (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        }
        cr = Utils.isEmpty((CharSequence)this.port) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.PortEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.PortOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.replyAddress) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ReplayAddressEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ReplayAddressOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.destination) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DestinationEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DestinationOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.subject) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SubjectEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SubjectOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.comment) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.CommentEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.CommentEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (this.isFilenameDynamic) {
            cr = Utils.isEmpty((CharSequence)this.dynamicFieldname) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicFilenameFieldEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicFilenameFieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = Utils.isEmpty((CharSequence)this.sourcefilefoldername) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SourceFilenameEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.SourceFilenameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isZipFiles()) {
            if (this.isFilenameDynamic) {
                cr = Utils.isEmpty((CharSequence)this.getDynamicZipFilenameField()) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicZipfilenameEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.DynamicZipfilenameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = Utils.isEmpty((CharSequence)this.zipFilename) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ZipfilenameEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MailMeta.CheckResult.ZipfilenameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public boolean isAddMessageToOutput() {
        return this.addMessageToOutput;
    }

    public void setAddMessageToOutput(boolean addMessageToOutput) {
        this.addMessageToOutput = addMessageToOutput;
    }

    public String getMessageOutputField() {
        return this.messageOutputField;
    }

    public void setMessageOutputField(String messageOutputField) {
        this.messageOutputField = messageOutputField;
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

