/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseVersion;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.JdbcConfig;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import com.clickhouse.logging.LoggerFactory;
import java.io.Serializable;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public class ClickHouseDriver
implements Driver {
    private static final com.clickhouse.logging.Logger log = LoggerFactory.getLogger(ClickHouseDriver.class);
    private static final Map<Object, ClickHouseOption> clientSpecificOptions;
    static final String driverVersionString;
    static final ClickHouseVersion driverVersion;
    static final ClickHouseVersion specVersion;
    static final Logger parentLogger;

    public static Map<ClickHouseOption, Serializable> toClientOptions(Properties props) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            String key = e.getKey().toString();
            Object o = ClickHouseClientOption.fromKey((String)key);
            if (o == null) {
                o = clientSpecificOptions.get(key);
            }
            if (o == null) continue;
            options.put((ClickHouseOption)o, ClickHouseOption.fromString(e.getValue().toString(), o.getValueType()));
        }
        return options;
    }

    private DriverPropertyInfo create(ClickHouseOption option, Properties props) {
        DriverPropertyInfo propInfo = new DriverPropertyInfo(option.getKey(), props.getProperty(option.getKey(), String.valueOf(option.getEffectiveDefaultValue())));
        propInfo.required = false;
        propInfo.description = option.getDescription();
        propInfo.choices = null;
        Class<? extends Serializable> clazz = option.getValueType();
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            propInfo.choices = new String[]{"true", "false"};
        } else if (clazz.isEnum()) {
            Serializable[] values = clazz.getEnumConstants();
            String[] names = new String[values.length];
            int index = 0;
            for (Serializable v : values) {
                names[index++] = ((Enum)((Object)v)).name();
            }
            propInfo.choices = names;
        }
        return propInfo;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && (url.startsWith("jdbc:clickhouse:") || url.startsWith("jdbc:ch:"));
    }

    @Override
    public ClickHouseConnection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        log.debug((Object)"Creating connection", new Object[0]);
        return new ClickHouseConnectionImpl(url, info);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            info = ClickHouseJdbcUrlParser.parse(url, info).getProperties();
        }
        catch (Exception e) {
            log.error((Object)"Could not parse url %s", url, e);
        }
        ArrayList<DriverPropertyInfo> result = new ArrayList<DriverPropertyInfo>(ClickHouseClientOption.values().length * 2);
        for (ClickHouseClientOption option : ClickHouseClientOption.values()) {
            result.add(this.create((ClickHouseOption)option, info));
        }
        for (ClickHouseOption option : clientSpecificOptions.values()) {
            result.add(this.create(option, info));
        }
        result.addAll(JdbcConfig.getDriverProperties());
        return result.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return driverVersion.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return driverVersion.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return parentLogger;
    }

    static {
        parentLogger = Logger.getLogger("com.clickhouse.jdbc");
        String str = ClickHouseDriver.class.getPackage().getImplementationVersion();
        if (str != null && !str.isEmpty()) {
            char[] chars = str.toCharArray();
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                if (!Character.isDigit(chars[i])) continue;
                str = str.substring(i);
                break;
            }
            driverVersionString = str;
        } else {
            driverVersionString = "";
        }
        driverVersion = ClickHouseVersion.of(driverVersionString);
        specVersion = ClickHouseVersion.of(ClickHouseDriver.class.getPackage().getSpecificationVersion());
        try {
            DriverManager.registerDriver(new ClickHouseDriver());
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        log.debug((Object)"ClickHouse Driver %s(JDBC: %s) registered", driverVersion, specVersion);
        LinkedHashMap<String, ClickHouseOption> m = new LinkedHashMap<String, ClickHouseOption>();
        try {
            for (ClickHouseClient c : ServiceLoader.load(ClickHouseClient.class, ClickHouseDriver.class.getClassLoader())) {
                Class clazz = c.getOptionClass();
                if (clazz == null || clazz == ClickHouseClientOption.class) continue;
                for (ClickHouseOption o : (ClickHouseOption[])clazz.getEnumConstants()) {
                    m.put(o.getKey(), o);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to load client-specific options", e);
        }
        clientSpecificOptions = Collections.unmodifiableMap(m);
    }
}

