/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util.metadata.builder;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.deltaspike.core.util.BeanUtils;
import org.apache.deltaspike.core.util.ReflectionUtils;
import org.apache.deltaspike.core.util.metadata.builder.ParameterValueRedefiner;

public class InjectableMethod<X> {
    private final AnnotatedMethod<X> method;
    private final List<InjectionPoint> parameters;
    private final BeanManager beanManager;

    public InjectableMethod(AnnotatedMethod<X> method, Bean<?> declaringBean, BeanManager beanManager) {
        this(method, BeanUtils.createInjectionPoints(method, declaringBean, beanManager), beanManager);
    }

    public InjectableMethod(AnnotatedMethod<X> method, Collection<InjectionPoint> parameters, BeanManager beanManager) {
        this.method = method;
        this.parameters = new ArrayList<InjectionPoint>(parameters);
        this.beanManager = beanManager;
    }

    protected BeanManager getBeanManager() {
        return this.beanManager;
    }

    protected List<InjectionPoint> getParameters() {
        return this.parameters;
    }

    public <T> T invoke(Object receiver, CreationalContext<T> creationalContext) throws IllegalAccessException, IllegalArgumentException {
        return this.invoke(receiver, creationalContext, null);
    }

    public <T> T invoke(Object receiver, CreationalContext<T> creationalContext, ParameterValueRedefiner redefinition) throws IllegalAccessException, IllegalArgumentException {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (int i = 0; i < this.getParameters().size(); ++i) {
            if (redefinition != null) {
                ParameterValueRedefiner.ParameterValue value = new ParameterValueRedefiner.ParameterValue(i, this.getParameters().get(i), this.getBeanManager());
                parameterValues.add(redefinition.redefineParameterValue(value));
                continue;
            }
            parameterValues.add(this.getBeanManager().getInjectableReference(this.getParameters().get(i), creationalContext));
        }
        try {
            Object result = ReflectionUtils.invokeMethod(receiver, this.method.getJavaMember(), Object.class, true, parameterValues.toArray());
            return (T)result;
        }
        catch (RuntimeException e) {
            if (RuntimeException.class.getName().equals(e.getClass().getName()) && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }
}

