/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.httpsignature.MessageSigner;
import org.apache.cxf.rs.security.httpsignature.exception.SignatureException;
import org.apache.cxf.rs.security.httpsignature.provider.KeyProvider;
import org.apache.cxf.rs.security.httpsignature.utils.KeyManagementUtils;

abstract class AbstractSignatureOutFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSignatureOutFilter.class);
    private MessageSigner messageSigner;
    private boolean enabled = true;

    AbstractSignatureOutFilter() {
    }

    protected void performSignature(MultivaluedMap<String, Object> headers, String uriPath, String httpMethod) {
        if (!this.enabled) {
            LOG.fine("Create signature filter is disabled");
            return;
        }
        if (this.messageSigner == null) {
            this.messageSigner = this.createMessageSigner();
        }
        if (headers.containsKey((Object)"Signature")) {
            LOG.fine("Message already contains a signature");
            return;
        }
        LOG.fine("Starting filter message signing process");
        Map<String, List<String>> convertedHeaders = this.convertHeaders(headers);
        try {
            this.messageSigner.sign(convertedHeaders, uriPath, httpMethod);
        }
        catch (IOException ex) {
            throw new SignatureException("Error creating signature", ex);
        }
        headers.put((Object)"Signature", Collections.singletonList(convertedHeaders.get("Signature").get(0)));
        LOG.fine("Finished filter message verification process");
    }

    private Map<String, List<String>> convertHeaders(MultivaluedMap<String, Object> requestHeaders) {
        HashMap<String, List<String>> convertedHeaders = new HashMap<String, List<String>>(requestHeaders.size());
        for (Map.Entry entry : requestHeaders.entrySet()) {
            convertedHeaders.put((String)entry.getKey(), ((List)entry.getValue()).stream().map(o -> o.toString().trim()).collect(Collectors.toList()));
        }
        return convertedHeaders;
    }

    public MessageSigner getMessageSigner() {
        return this.messageSigner;
    }

    public void setMessageSigner(MessageSigner messageSigner) {
        Objects.requireNonNull(messageSigner);
        this.messageSigner = messageSigner;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private MessageSigner createMessageSigner() {
        String keyId2;
        Properties props = KeyManagementUtils.loadSignatureOutProperties();
        if (props == null) {
            throw new SignatureException("Signature properties are not configured correctly");
        }
        Message m = PhaseInterceptorChain.getCurrentMessage();
        KeyProvider keyProvider = keyId -> KeyManagementUtils.loadPrivateKey(m, props);
        String signatureAlgorithm = (String)m.getContextualProperty("rs.security.signature.algorithm");
        if (signatureAlgorithm == null) {
            signatureAlgorithm = "rsa-sha256";
        }
        if ((keyId2 = (String)m.getContextualProperty("rs.security.http.signature.key.id")) == null && (keyId2 = props.getProperty("rs.security.http.signature.key.id")) == null) {
            throw new SignatureException("The signature key id is a required configuration property");
        }
        List<String> signedHeaders = CastUtils.cast((List)((List)m.getContextualProperty("rs.security.http.signature.out.headers")));
        if (signedHeaders == null) {
            signedHeaders = Collections.emptyList();
        }
        return new MessageSigner(signatureAlgorithm, keyProvider, keyId2, signedHeaders);
    }
}

