/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.util;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehcache.core.osgi.OsgiServiceLoader;
import org.ehcache.core.osgi.SafeOsgi;

public class ClassLoading {
    private static final ClassLoader DEFAULT_CLASSLOADER = ClassLoading.delegationChain(() -> Thread.currentThread().getContextClassLoader(), ChainedClassLoader.class.getClassLoader());

    public static ClassLoader getDefaultClassLoader() {
        return DEFAULT_CLASSLOADER;
    }

    public static <T> Iterable<T> servicesOfType(Class<T> serviceType) {
        if (SafeOsgi.useOSGiServiceLoading()) {
            return OsgiServiceLoader.load(serviceType);
        }
        return ServiceLoader.load(serviceType, ClassLoading.class.getClassLoader());
    }

    public static ClassLoader delegationChain(Supplier<ClassLoader> loader, ClassLoader ... loaders) {
        return AccessController.doPrivileged(() -> new ChainedClassLoader(Stream.concat(Stream.of(loader), Stream.of(loaders).map(l -> () -> l)).collect(Collectors.toList())));
    }

    public static ClassLoader delegationChain(ClassLoader ... loaders) {
        return AccessController.doPrivileged(() -> new ChainedClassLoader(Stream.of(loaders).map(l -> () -> l).collect(Collectors.toList())));
    }

    private static class ChainedClassLoader
    extends ClassLoader {
        private final List<Supplier<ClassLoader>> loaders;

        public ChainedClassLoader(List<Supplier<ClassLoader>> loaders) {
            this.loaders = loaders;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            ClassNotFoundException lastFailure = new ClassNotFoundException(name);
            for (Supplier<ClassLoader> loader : this.loaders) {
                ClassLoader classLoader = loader.get();
                if (classLoader == null) continue;
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    lastFailure = cnfe;
                }
            }
            throw lastFailure;
        }

        @Override
        public URL getResource(String name) {
            for (Supplier<ClassLoader> loader : this.loaders) {
                URL resource;
                ClassLoader classLoader = loader.get();
                if (classLoader == null || (resource = classLoader.getResource(name)) == null) continue;
                return resource;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> aggregate = new ArrayList<URL>();
            for (Supplier<ClassLoader> loader : this.loaders) {
                ClassLoader classLoader = loader.get();
                if (classLoader == null) continue;
                aggregate.addAll(Collections.list(classLoader.getResources(name)));
            }
            return Collections.enumeration(aggregate);
        }
    }
}

