/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jci.compilers.AbstractCompilerTestCase;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.RhinoJavaCompiler;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;

public final class RhinoJavaCompilerTestCase
extends AbstractCompilerTestCase {
    public JavaCompiler createJavaCompiler() {
        return new RhinoJavaCompiler();
    }

    public String getCompilerName() {
        return "rhino";
    }

    public void testSimpleCompile() throws Exception {
        JavaCompiler compiler = this.createJavaCompiler();
        ResourceReader reader = new ResourceReader(){
            private final Map<String, byte[]> sources = new HashMap<String, byte[]>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("jci/Simple.js", " var i = 0;\n\n".getBytes());
                }
            };

            public byte[] getBytes(String pResourceName) {
                return this.sources.get(pResourceName);
            }

            public boolean isAvailable(String pResourceName) {
                return this.sources.containsKey(pResourceName);
            }
        };
        MemoryResourceStore store = new MemoryResourceStore();
        CompilationResult result = compiler.compile(new String[]{"jci/Simple.js"}, reader, (ResourceStore)store);
        RhinoJavaCompilerTestCase.assertEquals((String)this.toString(result.getErrors()), (int)0, (int)result.getErrors().length);
        RhinoJavaCompilerTestCase.assertEquals((String)this.toString(result.getWarnings()), (int)0, (int)result.getWarnings().length);
        byte[] clazzBytes = store.read("jci/Simple.class");
        RhinoJavaCompilerTestCase.assertNotNull((Object)clazzBytes);
        RhinoJavaCompilerTestCase.assertTrue((clazzBytes.length > 0 ? 1 : 0) != 0);
    }

    public void testExtendedCompile() throws Exception {
    }

    public void testInternalClassCompile() throws Exception {
    }

    public void testUppercasePackageNameCompile() throws Exception {
        JavaCompiler compiler = this.createJavaCompiler();
        ResourceReader reader = new ResourceReader(){
            private final Map<String, byte[]> sources = new HashMap<String, byte[]>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("Jci/Simple.js", " var i = 0;\n\n".getBytes());
                }
            };

            public byte[] getBytes(String pResourceName) {
                return this.sources.get(pResourceName);
            }

            public boolean isAvailable(String pResourceName) {
                return this.sources.containsKey(pResourceName);
            }
        };
        MemoryResourceStore store = new MemoryResourceStore();
        CompilationResult result = compiler.compile(new String[]{"Jci/Simple.js"}, reader, (ResourceStore)store);
        RhinoJavaCompilerTestCase.assertEquals((String)this.toString(result.getErrors()), (int)0, (int)result.getErrors().length);
        RhinoJavaCompilerTestCase.assertEquals((String)this.toString(result.getWarnings()), (int)0, (int)result.getWarnings().length);
        byte[] clazzBytes = store.read("Jci/Simple.class");
        RhinoJavaCompilerTestCase.assertNotNull((Object)clazzBytes);
        RhinoJavaCompilerTestCase.assertTrue((clazzBytes.length > 0 ? 1 : 0) != 0);
    }

    public void testCrossReferenceCompilation() throws Exception {
    }

    public void testAdditionalTopLevelClassCompile() throws Exception {
    }
}

