/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.AbstractCombinerTest;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.UnionCombiner;
import org.junit.Assert;
import org.junit.Test;

public class TestUnionCombiner
extends AbstractCombinerTest {
    protected NodeCombiner createCombiner() {
        return new UnionCombiner();
    }

    @Test
    public void testSimpleValues() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Too few bgcolors", (long)1L, (long)config.getMaxIndex("gui.bgcolor"));
        Assert.assertEquals((String)"Wrong first color", (Object)"green", (Object)config.getString("gui.bgcolor(0)"));
        Assert.assertEquals((String)"Wrong second color", (Object)"black", (Object)config.getString("gui.bgcolor(1)"));
        Assert.assertEquals((String)"Wrong number of selcolors", (long)0L, (long)config.getMaxIndex("gui.selcolor"));
        Assert.assertEquals((String)"Wrong selcolor", (Object)"yellow", (Object)config.getString("gui.selcolor"));
    }

    @Test
    public void testSimpleValuesWithAttributes() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Too few level elements", (long)1L, (long)config.getMaxIndex("gui.level"));
        Assert.assertEquals((String)"Wrong value of first element", (long)1L, (long)config.getInt("gui.level(0)"));
        Assert.assertEquals((String)"Wrong value of second element", (long)4L, (long)config.getInt("gui.level(1)"));
        Assert.assertEquals((String)"Wrong value of first attribute", (long)2L, (long)config.getInt("gui.level(0)[@default]"));
        Assert.assertFalse((String)"Found wrong attribute", (boolean)config.containsKey("gui.level(0)[@min]"));
        Assert.assertEquals((String)"Wrong value of second attribute", (long)1L, (long)config.getInt("gui.level(1)[@min]"));
    }

    @Test
    public void testAttributes() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Too few attributes", (long)1L, (long)config.getMaxIndex("database.tables.table(0)[@id]"));
        Assert.assertEquals((String)"Wrong value of first attribute", (long)1L, (long)config.getInt("database.tables.table(0)[@id](0)"));
        Assert.assertEquals((String)"Wrong value of second attribute", (long)2L, (long)config.getInt("database.tables.table(0)[@id](1)"));
    }

    @Test
    public void testLists() throws ConfigurationException {
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Too few list elements", (long)2L, (long)config.getMaxIndex("net.service.url"));
        Assert.assertEquals((String)"Wrong first service", (Object)"http://service1.org", (Object)config.getString("net.service.url(0)"));
        Assert.assertEquals((String)"Wrong second service", (Object)"http://service2.org", (Object)config.getString("net.service.url(1)"));
        Assert.assertEquals((String)"Wrong service attribute", (long)2L, (long)config.getInt("net.service.url(2)[@type]"));
        Assert.assertEquals((String)"Wrong number of server elements", (long)3L, (long)config.getMaxIndex("net.server.url"));
    }

    @Test
    public void testTableList() throws ConfigurationException {
        this.combiner.addListNode("table");
        HierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong name of first table", (Object)"documents", (Object)config.getString("database.tables.table(0).name"));
        Assert.assertEquals((String)"Wrong id of first table", (long)1L, (long)config.getInt("database.tables.table(0)[@id]"));
        Assert.assertEquals((String)"Wrong name of second table", (Object)"tasks", (Object)config.getString("database.tables.table(1).name"));
        Assert.assertEquals((String)"Wrong id of second table", (long)2L, (long)config.getInt("database.tables.table(1)[@id]"));
    }
}

